<?php

declare(strict_types=1);

/*
 * This file is part of the Sonata Project package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\UserBundle\Document;

use Sonata\UserBundle\Model\User as AbstractedUser;
use Sonata\UserBundle\Model\UserInterface;

/**
 * Represents a Base User Document.
 */
class BaseUser extends AbstractedUser implements UserInterface
{
    /**
     * Hook on pre-persist operations.
     */
    public function prePersist(): void
    {
        $this->createdAt = new \DateTime();
        $this->updatedAt = new \DateTime();
    }

    /**
     * Hook on pre-update operations.
     */
    public function preUpdate(): void
    {
        $this->updatedAt = new \DateTime();
    }
}
