/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.image.DefineImage;
import com.flagstone.transform.image.DefineImage2;
import com.flagstone.transform.image.ImageFormat;
import com.flagstone.transform.image.ImageTag;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.swing.ImageIcon;

public final class BufferedImageEncoder {
    private static final int BYTES_PER_PIXEL = 4;
    private static final int OPAQUE = -1;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private static final int MASK_5BIT = 31;
    private static final int MASK_8BIT = 255;
    private static final int ALIGN_BYTE2 = 8;
    private static final int ALIGN_BYTE3 = 16;
    private static final int ALIGN_BYTE4 = 24;
    private static final int WORD_ALIGN = 3;
    private static final int RGB5_SIZE = 16;
    private transient ImageFormat format;
    private transient int width;
    private transient int height;
    private transient byte[] table;
    private transient byte[] image;

    public void setImage(ImageTag definition) throws DataFormatException {
        if (definition instanceof DefineImage) {
            this.setImage((DefineImage)definition);
        } else if (definition instanceof DefineImage2) {
            this.setImage((DefineImage2)definition);
        }
    }

    public void setImage(DefineImage definition) throws DataFormatException {
        this.width = definition.getWidth();
        this.height = definition.getHeight();
        if (definition.getTableSize() > 0) {
            this.setIDX(definition);
        } else if (definition.getPixelSize() == 16) {
            this.setRGB5(definition);
        } else {
            this.setRGB8(definition);
        }
    }

    public void setImage(DefineImage2 definition) throws DataFormatException {
        if (definition.getTableSize() > 0) {
            this.setIDXA(definition);
        } else {
            this.setRGBA(definition);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getImage() {
        return Arrays.copyOf(this.image, this.image.length);
    }

    private void setIDX(DefineImage definition) throws DataFormatException {
        byte[] data = this.unzip(definition.getImage(), this.width, this.height);
        int scanLength = this.width + 3 & 0xFFFFFFFC;
        int tableLength = definition.getTableSize();
        int pos = 0;
        int index = 0;
        this.format = ImageFormat.IDX8;
        this.table = new byte[tableLength * 4];
        this.image = new byte[this.height * this.width];
        int i = 0;
        while (i < tableLength) {
            this.table[index + 3] = -1;
            this.table[index + 2] = data[pos++];
            this.table[index + 1] = data[pos++];
            this.table[index] = data[pos++];
            ++i;
            index += 4;
        }
        index = 0;
        for (int h = 0; h < this.height; ++h) {
            int w = 0;
            while (w < this.width) {
                this.image[index] = data[pos++];
                ++w;
                ++index;
            }
            pos += scanLength - this.width;
        }
    }

    private void setRGB5(DefineImage definition) throws DataFormatException {
        byte[] data = this.unzip(definition.getImage(), this.width, this.height);
        int scanLength = this.width + 3 & 0xFFFFFFFC;
        int pos = 0;
        int index = 0;
        this.format = ImageFormat.RGB8;
        this.image = new byte[this.height * this.width * 4];
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                int color = (data[pos++] << 8 | data[pos++] & 0xFF) & Short.MAX_VALUE;
                this.image[index + 3] = -1;
                this.image[index + 0] = (byte)(color >> 10);
                this.image[index + 1] = (byte)(color >> 5 & 0x1F);
                this.image[index + 2] = (byte)(color & 0x1F);
                index += 4;
            }
            pos += scanLength - this.width;
        }
    }

    private void setRGB8(DefineImage definition) throws DataFormatException {
        byte[] data = this.unzip(definition.getImage(), this.width, this.height);
        int scanLength = this.width + 3 & 0xFFFFFFFC;
        int pos = 0;
        int index = 0;
        this.format = ImageFormat.RGB8;
        this.image = new byte[this.height * this.width * 4];
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                this.image[index + 3] = -1;
                this.image[index + 0] = data[pos++];
                this.image[index + 1] = data[pos++];
                this.image[index + 2] = data[pos++];
                index += 4;
            }
            pos += scanLength - this.width;
        }
    }

    private void setIDXA(DefineImage2 definition) throws DataFormatException {
        this.width = definition.getWidth();
        this.height = definition.getHeight();
        byte[] data = this.unzip(definition.getImage(), this.width, this.height);
        int scanLength = this.width + 3 & 0xFFFFFFFC;
        int tableLength = definition.getTableSize();
        int pos = 0;
        int index = 0;
        this.format = ImageFormat.IDXA;
        this.table = new byte[tableLength * 4];
        this.image = new byte[this.height * this.width];
        int i = 0;
        while (i < tableLength) {
            this.table[index + 3] = data[pos++];
            this.table[index + 2] = data[pos++];
            this.table[index + 1] = data[pos++];
            this.table[index] = data[pos++];
            ++i;
            index += 4;
        }
        index = 0;
        for (int h = 0; h < this.height; ++h) {
            int w = 0;
            while (w < this.width) {
                this.image[index] = data[pos++];
                ++w;
                ++index;
            }
            pos += scanLength - this.width;
        }
    }

    private void setRGBA(DefineImage2 definition) throws DataFormatException {
        this.width = definition.getWidth();
        this.height = definition.getHeight();
        byte[] data = this.unzip(definition.getImage(), this.width, this.height);
        int pos = 0;
        int index = 0;
        this.image = new byte[this.height * this.width * 4];
        for (int h = 0; h < this.height; ++h) {
            int w = 0;
            while (w < this.width) {
                this.image[index + 3] = data[pos++];
                this.image[index + 0] = data[pos++];
                this.image[index + 1] = data[pos++];
                this.image[index + 2] = data[pos++];
                ++w;
                index += 4;
            }
        }
    }

    public BufferedImage getBufferedImage() {
        BufferedImage bufferedImage = this.format == ImageFormat.IDX8 || this.format == ImageFormat.IDXA ? this.getIndexedImage() : this.getRGBAImage();
        return bufferedImage;
    }

    private BufferedImage getIndexedImage() {
        byte[] red = new byte[this.table.length];
        byte[] green = new byte[this.table.length];
        byte[] blue = new byte[this.table.length];
        byte[] alpha = new byte[this.table.length];
        int count = this.table.length / 4;
        int index = 0;
        for (int i = 0; i < count; ++i) {
            red[i] = this.table[index + 2];
            green[i] = this.table[index + 1];
            blue[i] = this.table[index + 0];
            alpha[i] = this.table[index + 3];
            index += 4;
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        int[] row = new int[this.width];
        index = 0;
        for (int i = 0; i < this.height; ++i) {
            int j = 0;
            while (j < this.width) {
                int color = (this.image[index] & 0xFF) << 2;
                row[j] = (this.table[color + 3] & 0xFF) << 24;
                row[j] = row[j] | (this.table[color + 2] & 0xFF) << 16;
                row[j] = row[j] | (this.table[color + 1] & 0xFF) << 8;
                row[j] = row[j] | this.table[color + 0] & 0xFF;
                ++j;
                ++index;
            }
            bufferedImage.setRGB(0, i, this.width, 1, row, 0, this.width);
        }
        return bufferedImage;
    }

    private BufferedImage getRGBAImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        int[] buffer = new int[this.width];
        int index = 0;
        for (int i = 0; i < this.height; ++i) {
            int j = 0;
            while (j < this.width) {
                buffer[j] = (this.image[index + 3] & 0xFF) << 24;
                buffer[j] = buffer[j] | (this.image[index + 0] & 0xFF) << 16;
                buffer[j] = buffer[j] | (this.image[index + 1] & 0xFF) << 8;
                buffer[j] = buffer[j] | this.image[index + 2] & 0xFF;
                ++j;
                index += 4;
            }
            bufferedImage.setRGB(0, i, this.width, 1, buffer, 0, this.width);
        }
        return bufferedImage;
    }

    public BufferedImage resizeImage(BufferedImage bufferedImg, int imgWidth, int imgHeight) {
        double heightRatio;
        double ratio;
        int imageType = bufferedImg.getType();
        if (imageType == 0) {
            imageType = 6;
        }
        BufferedImage resized = new BufferedImage(imgWidth, imgHeight, 6);
        double widthRatio = (double)bufferedImg.getWidth() / (double)imgWidth;
        double d = ratio = widthRatio > (heightRatio = (double)bufferedImg.getHeight() / (double)imgHeight) ? widthRatio : heightRatio;
        if (ratio < 1.0) {
            ratio = 1.0;
        }
        int imageWidth = (int)((double)bufferedImg.getWidth() / ratio);
        int imageHeight = (int)((double)bufferedImg.getHeight() / ratio);
        int xCoord = imgWidth - imageWidth >> 1;
        int yCoord = imgHeight - imageHeight >> 1;
        Graphics2D graphics = resized.createGraphics();
        graphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        graphics.fillRect(0, 0, imgWidth, imgHeight);
        Image scaled = bufferedImg.getScaledInstance(imageWidth, imageHeight, 4);
        new ImageIcon(scaled);
        graphics.drawImage(scaled, xCoord, yCoord, null);
        graphics.dispose();
        resized.flush();
        new ImageIcon(resized).getImage();
        return resized;
    }

    private byte[] unzip(byte[] bytes, int imgWidth, int imgHeight) throws DataFormatException {
        byte[] data = new byte[imgWidth * imgHeight * 8];
        int count = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(bytes);
        count = inflater.inflate(data);
        inflater.end();
        byte[] uncompressedData = new byte[count];
        System.arraycopy(data, 0, uncompressedData, 0, count);
        return uncompressedData;
    }
}

