/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.coder.BigDecoder;
import com.flagstone.transform.image.DefineJPEGImage2;
import com.flagstone.transform.image.ImageTag;
import com.flagstone.transform.image.JPEGInfo;
import com.flagstone.transform.util.image.ImageDecoder;
import com.flagstone.transform.util.image.ImageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public final class JPGDecoder
implements ImageProvider,
ImageDecoder {
    private static final String BAD_FORMAT = "Unsupported format";
    private transient int width;
    private transient int height;
    private transient byte[] image = new byte[0];

    @Override
    public void read(File file) throws IOException, DataFormatException {
        this.read(new FileInputStream(file));
    }

    @Override
    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        if (!connection.getContentType().equals("image/bmp")) {
            throw new DataFormatException(BAD_FORMAT);
        }
        int length = connection.getContentLength();
        if (length < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        this.read(url.openStream());
    }

    @Override
    public ImageTag defineImage(int identifier) {
        return new DefineJPEGImage2(identifier, this.image);
    }

    @Override
    public ImageDecoder newDecoder() {
        return new JPGDecoder();
    }

    @Override
    public void read(InputStream stream) throws DataFormatException, IOException {
        int marker;
        BigDecoder coder = new BigDecoder(stream);
        do {
            marker = coder.readUnsignedShort();
            switch (marker) {
                case 65496: 
                case 65497: {
                    this.copyTag(marker, 0, coder);
                    break;
                }
                case 65472: 
                case 65474: 
                case 65476: 
                case 65499: 
                case 65534: {
                    int length = coder.readUnsignedShort();
                    this.copyTag(marker, length, coder);
                    break;
                }
                case 65498: {
                    int length = coder.readUnsignedShort();
                    this.copyTag(marker, length, coder);
                    this.readEntropyData(coder);
                    break;
                }
                case 65501: {
                    this.copyTag(marker, 0, coder);
                    this.readEntropyData(coder);
                    break;
                }
                default: {
                    int length;
                    if ((marker & 0xFFE0) == 65504) {
                        length = coder.readUnsignedShort();
                        this.copyTag(marker, length, coder);
                        break;
                    }
                    this.copyTag(marker, 0, coder);
                }
            }
        } while (marker != 65497);
        JPEGInfo info = new JPEGInfo();
        info.decode(this.image);
        this.width = info.getWidth();
        this.height = info.getHeight();
    }

    private void copyTag(int marker, int length, BigDecoder coder) throws IOException {
        byte[] bytes = length > 0 ? new byte[length + 2] : new byte[]{(byte)(marker >> 8), (byte)marker};
        if (length > 0) {
            bytes[2] = (byte)(length >> 8);
            bytes[3] = (byte)length;
            coder.readBytes(bytes, 4, length - 2);
        }
        int imgLength = this.image.length;
        this.image = Arrays.copyOf(this.image, imgLength + bytes.length);
        System.arraycopy(bytes, 0, this.image, imgLength, bytes.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readEntropyData(BigDecoder coder) throws IOException {
        byte[] bytes = new byte[2048];
        int index = 0;
        while (true) {
            block7: {
                int imgLength;
                coder.mark();
                int current = coder.readByte();
                if (current == 255) {
                    int next = coder.readByte();
                    if (next == 0) {
                        if (index + 2 >= bytes.length) {
                            imgLength = this.image.length;
                            this.image = Arrays.copyOf(this.image, imgLength + index);
                            System.arraycopy(bytes, 0, this.image, imgLength, index);
                            index = 0;
                        }
                        bytes[index++] = (byte)current;
                        bytes[index++] = (byte)next;
                        break block7;
                    } else {
                        if (index > 0) {
                            imgLength = this.image.length;
                            this.image = Arrays.copyOf(this.image, imgLength + index);
                            System.arraycopy(bytes, 0, this.image, imgLength, index);
                            index = 0;
                        }
                        coder.reset();
                        return;
                    }
                }
                if (index >= bytes.length) {
                    imgLength = this.image.length;
                    this.image = Arrays.copyOf(this.image, imgLength + bytes.length);
                    System.arraycopy(bytes, 0, this.image, imgLength, bytes.length);
                    index = 0;
                }
                bytes[index++] = (byte)current;
            }
            coder.unmark();
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public byte[] getImage() {
        return Arrays.copyOf(this.image, this.image.length);
    }
}

